package furny;

import java.io.InputStream;
import java.util.concurrent.Callable;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.jme3.app.SimpleApplication;
import com.jme3.system.AppSettings;

import furny.furndb.FurnCache;
import furny.jme.FurnyApplication;
import furny.util.LoggerUtil;
import ga.view.appstate.roomplanner.RoomPlanner;
import ga.view.config.ViewSettings;

/**
 * @deprecated This class never reached a usable state and will be removed soon.
 * @since 12.08.2012
 * @author Stephan Dreyer
 */
@Deprecated
public final class RoomPlannerTest {
  private static final Logger LOGGER = LoggerFactory
      .getLogger(RoomPlannerTest.class);

  /**
   * @deprecated This class never reached a usable state and will be removed
   *             soon.
   * @since 12.08.2012
   * @author Stephan Dreyer
   */
  @Deprecated
  private RoomPlannerTest() {
  }

  /**
   * @deprecated This class never reached a usable state and will be removed
   *             soon.
   * @since 12.08.2012
   * @author Stephan Dreyer
   */
  @Deprecated
  public static void main(final String[] args) {
    LoggerUtil.installLogger();

    int qualitylevel = 0;
    for (final String arg : args) {
      if (arg.startsWith("-q")) {
        qualitylevel = Integer.valueOf(arg.substring(2));
      } else if (arg.startsWith("--quality=")) {
        qualitylevel = Integer.valueOf(arg.substring(arg.indexOf('=') + 1));
      }
    }

    final String settingsFileName = "furny/view/settings" + qualitylevel
        + ".properties";

    FurnCache.getInstance();

    final ViewSettings viewSettings = ViewSettings
        .buildFromXml("furny/test/FurnyGA.xml");
    // final MTIEvaluator app = new MTIEvaluator(viewSettings);
    final SimpleApplication app = new FurnyApplication();

    final RoomPlanner rp = new RoomPlanner(viewSettings);

    app.enqueue(new Callable<Void>() {
      @Override
      public Void call() throws Exception {
        app.getStateManager().attach(rp);
        return null;
      }
    });

    final AppSettings settings = new AppSettings(true);
    settings.setResolution(1280, 1024);

    try {
      final InputStream is = RoomPlannerTest.class.getClassLoader()
          .getResourceAsStream(settingsFileName);
      settings.load(is);
      is.close();
      app.setShowSettings(false);
    } catch (final Exception e) {
      settings.setResolution(1024, 768);
      settings.put("ShowCursor", Boolean.TRUE);
    }

    app.setSettings(settings);

    LOGGER.debug("Starting evaluator");

    app.start();
  }
}
